//SQLite database manipulation functions
//Designed by : ABHISHEK KUMAR (140250330004)

//############################################################################################################################
struct meter_param{//structure to hold energy meter parameters
	unsigned int id;
	unsigned char* date_time;
	float voltage;
	float current;
	float act_power;
	float rea_power;
	float app_power;
	float pf;
	unsigned int freq;
	float temp;	
};

//################################################################################################## HELPING FUNCTIONS : SQLite
//callback provides a way to obtain results from SELECT statements
int callback(void *data, int argc, char **argv, char **azColName)
{
   int i;
   for(i=0; i<argc; i++){
      printf("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
   }
   printf("\n");
   return 0;
}

//for fetching row count in a table
int callback_count(void *data, int argc, char **argv, char **azColName)
{
	if(1==argc)
	{
		*(unsigned int*)data = atoi(argv[0]);//fill the count in variable
		return 0; //depict success
	}
	return -1;//depict failure 
}

//for fetching rows data in a table
int callback_fetch(void *data, int argc, char **argv, char **azColName)
{
	//now extract the query results
	if(10==argc)
	{
		//fill the retrieved data in the meter_param structure passed
	  	((struct meter_param*)data)->id = atoi(argv[1]);
		((struct meter_param*)data)->date_time = argv[2];
		((struct meter_param*)data)->voltage = strtof(argv[3],NULL);
		((struct meter_param*)data)->current = strtof(argv[4],NULL);
		((struct meter_param*)data)->act_power = strtof(argv[5],NULL);
		((struct meter_param*)data)->rea_power = strtof(argv[6],NULL);
		((struct meter_param*)data)->app_power = strtof(argv[7],NULL);
		((struct meter_param*)data)->pf = strtof(argv[8],NULL);
		((struct meter_param*)data)->freq = atoi(argv[9]); 

	/*	printf("ID = %u\n",((struct meter_param*)data)->id);
		printf("Date-time = %s\n",((struct meter_param*)data)->date_time);
		printf("Voltage = %f\n",((struct meter_param*)data)->voltage);
		printf("Current = %f\n",((struct meter_param*)data)->current);
		printf("Active power = %f\n",((struct meter_param*)data)->act_power);
		printf("Reactive power = %f\n",((struct meter_param*)data)->rea_power);
		printf("Apparent power = %f\n",((struct meter_param*)data)->app_power);
		printf("PF = %f\n",((struct meter_param*)data)->pf);
		printf("Frequency = %d\n",((struct meter_param*)data)->freq);
		printf("\n\n");
	*/
		return 0;//depict success
	}

	return -1;//depict failure
}


sqlite3 *db_open(char *dbname)//to open/create a new database
{
	sqlite3 *db;//database object pointer
	char dbfile[25];//to hold the database name 	
	int rc;
	
	sprintf(dbfile,"%s.db",dbname);//make full database file name
	
	//This routine opens a connection to an SQLite database file and returns a database connection object to be used by other SQLite 		routines.If the filename argument is NULL or ':memory:', sqlite3_open() will create an in-memory database in RAM that lasts only for 		the duration of the session.If filename is not NULL, sqlite3_open() attempts to open the database file by using its value. If no file 		by that name exists, sqlite3_open() will open a new database file by that name.	
	rc = sqlite3_open(dbfile,&db);
	if(rc){
	     printf("XXXX : Can't open database: %s\n", sqlite3_errmsg(db));
	     return NULL;
	}
    	
	printf("@=> Database \"%s\" created/opened successfully\n",dbfile);
	return db;//return the newly allocated database handler
}

int db_create_table(sqlite3 *db,char *table_name)//to create a new meter table
{
	char *zErrMsg = NULL,sql[300];
	int rc;

	// Create SQL statement with required table name
   	sprintf(sql,"CREATE TABLE %s (SR_NO INTEGER PRIMARY KEY AUTOINCREMENT," \ 
         "ID INTEGER NOT NULL," \
         "DATE_TIME TEXT," \
         "VOLTAGE REAL," \
         "CURRENT REAL," \
         "ACTIVE_POWER REAL," \
         "REACTIVE_POWER REAL," \
         "APPARENT_POWER REAL," \
         "PF REAL," \
	 "FREQ INTEGER);",table_name);

	// Execute SQL statement 
	rc = sqlite3_exec(db,sql,callback,NULL,&zErrMsg);
	if(rc!=SQLITE_OK){
		printf("XXXX : SQL error (Table = %s) - %s\n",table_name,zErrMsg);
	    	sqlite3_free(zErrMsg);
		return -1;//depict failure
	}

	printf("@=> Table \"%s\" created successfully!!\n",table_name);
	return 0;//depict success
}

int db_insert(sqlite3 *db,char *table_name,struct meter_param *m1)//insert values into table
{
	char *zErrMsg = NULL,sql[300];
	int rc;

	// Create SQL statement with required table name and data
   	sprintf(sql,"INSERT INTO %s (ID,DATE_TIME,VOLTAGE,CURRENT,ACTIVE_POWER,REACTIVE_POWER,APPARENT_POWER,PF,FREQ) " 		    			    "VALUES (%d, '%s', '%3.2f', '%3.2f', '%3.2f', '%3.2f', '%3.2f', '%2.2f', '%u');",table_name,
		    m1->id,m1->date_time,m1->voltage,m1->current,m1->act_power,m1->rea_power,m1->app_power,m1->pf,m1->freq);

	//printf("INSERT INTO %s (ID,DATE_TIME,VOLTAGE,CURRENT,ACTIVE_POWER,REACTIVE_POWER,APPARENT_POWER,PF,FREQ)"/ 		    	    		//	"VALUES (%d, '%s', '%3.2f', '%3.2f', '%3.2f', '%3.2f', '%3.2f', '%2.2f', '%u');",table_name,m1->id,m1->date_time,
	//	m1->voltage,m1->current,m1->act_power,m1->rea_power,m1->app_power,m1->pf,m1->freq);
	
	// Execute SQL statement 
	rc = sqlite3_exec(db,sql,callback,NULL,&zErrMsg);
	if( rc != SQLITE_OK ){
		printf("XXXX : SQL error - %s\n", zErrMsg);
	    	sqlite3_free(zErrMsg);
		return -1;//depict failure
	}

	printf("@=> Database values inserted successfully!!\n");
	return 0;//depict success
}

struct meter_param* db_read(sqlite3 *db,char *table_name,unsigned int row)//to read a specified row from a table,returns NULL on error
{
	//dynamically allocate a structure,user will release it after use
	struct meter_param *x= (struct meter_param*)malloc(sizeof(struct meter_param));
	char sql[100],*zErrMsg = NULL;
	int rc;

	sprintf(sql,"SELECT * FROM %s WHERE SR_NO = %u",table_name,row);//create fetch command
	//sprintf(sql,"SELECT * FROM %s",table_name);//create fetch command

	// Execute SQL statement 
	rc = sqlite3_exec(db, sql, callback_fetch, &x, &zErrMsg);
	if( rc != SQLITE_OK ){
		printf("XXXX : SQL error - %s\n", zErrMsg);
	    	sqlite3_free(zErrMsg);
		free(x);
		return NULL;//depict failure
	}

	printf("@=> Values read successfully!!\n");
	return x;//depict 
}

unsigned char *get_date_time(void)
{
	struct timeval t;
	struct timezone tz;
	if(0==gettimeofday(&t,&tz))
	{
		//printf("Date-time = %s\n",ctime(&t.tv_sec));//FORMAT = Tue Jul 29 14:39:02 2014
		unsigned char *d = ctime(&t.tv_sec);
		d[strlen(d)-1] = '\0';//remove '\n' at the end of this string	
		return d;
	}
	
	return NULL;//fail to get date_time
}

unsigned int db_countrow(sqlite3 *db,char* table_name)
{
	unsigned int c;
	char sql[100],*zErrMsg = NULL;
	int rc;

	sprintf(sql,"SELECT count(*) FROM %s",table_name);//create count command

	// Execute SQL statement 
	rc = sqlite3_exec(db, sql, callback_count, &c, &zErrMsg);
	if( rc != SQLITE_OK ){
		printf("XXXX : SQL error - %s\n", zErrMsg);
	    	sqlite3_free(zErrMsg);
		return NULL;//depict failure
	}

	//printf("Count retrieved = %u!!\n",c);
	return c;//depict 

}
 
